/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWConfigPerformancePane
extends JPanel {
    private static final int COLUMN_WIDTH = 60;
    private static final int TOP_MARGIN = 4;
    private static final int BOTTOM_MARGIN = 4;
    private static final int LEFT_MARGIN = 4;
    private static final int RIGHT_MARGIN = 10;
    protected JCheckBox m_enableStatisticsCheckBox = null;
    protected JComboBox m_opPerTxComboBox = null;
    protected JComboBox m_instPerTxComboBox = null;
    protected JCheckBox m_enableTrackAttachmentsCheckBox = null;
    protected JTextField m_objectStoreIdTextField = null;
    protected VWSystemConfiguration m_sysConfig = null;
    protected DefaultComboBoxModel m_modelOperationPerTx = null;
    protected DefaultComboBoxModel m_modelInstructionPerTx = null;
    protected int m_originalMaxOpPerTx;
    protected int m_originalMaxInstPerTx;
    public boolean m_bDirty = false;

    public VWConfigPerformancePane(VWSystemConfiguration sysConfig) {
        try {
            this.m_sysConfig = sysConfig;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.insets = new Insets(4, 4, 4, 10);
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.fill = 2;
            ++gbConst.gridy;
            this.add((Component)this.createPerformancePanel(), gbConst);
            ++gbConst.gridy;
            this.add((Component)this.createTrackAttachmentsPanel(), gbConst);
            ++gbConst.gridy;
            this.add((Component)this.createObjectStoreIdPanel(), gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            this.add(Box.createVerticalStrut(100), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int fetchMaxInstructionPerTx() {
        int iMaxInstructionPerTx = 0;
        String sMaxInstructionPerTx = (String)this.m_modelInstructionPerTx.getSelectedItem();
        if (sMaxInstructionPerTx != null) {
            try {
                iMaxInstructionPerTx = Integer.valueOf(sMaxInstructionPerTx);
                if (this.m_sysConfig.getIsRetrievedFromServer() && (iMaxInstructionPerTx > 10000 || iMaxInstructionPerTx < 1)) {
                    iMaxInstructionPerTx = 0;
                    JOptionPane.showMessageDialog(this, VWResource.InvalidMaxInstPerTx.toString(sMaxInstructionPerTx), VWResource.ErrorMessage, 0);
                    this.m_modelInstructionPerTx.setSelectedItem(String.valueOf(this.m_originalMaxInstPerTx));
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidMaxInstPerTx.toString(sMaxInstructionPerTx), VWResource.ErrorMessage, 0);
                this.m_modelInstructionPerTx.setSelectedItem(String.valueOf(this.m_originalMaxInstPerTx));
            }
        }
        return iMaxInstructionPerTx;
    }

    public int fetchMaxOperationPerTx() {
        int iMaxOperationPerTx = 0;
        String sMaxOperationPerTx = (String)this.m_modelOperationPerTx.getSelectedItem();
        if (sMaxOperationPerTx != null) {
            try {
                iMaxOperationPerTx = Integer.valueOf(sMaxOperationPerTx);
                if (this.m_sysConfig.getIsRetrievedFromServer() && (iMaxOperationPerTx > 10000 || iMaxOperationPerTx < 1)) {
                    iMaxOperationPerTx = 0;
                    JOptionPane.showMessageDialog(this, VWResource.InvalidMaxDbOpPerTx.toString(sMaxOperationPerTx), VWResource.ErrorMessage, 0);
                    this.m_modelOperationPerTx.setSelectedItem(String.valueOf(this.m_originalMaxOpPerTx));
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidMaxDbOpPerTx.toString(sMaxOperationPerTx), VWResource.ErrorMessage, 0);
                this.m_modelOperationPerTx.setSelectedItem(String.valueOf(this.m_originalMaxOpPerTx));
            }
        }
        return iMaxOperationPerTx;
    }

    public boolean update() {
        boolean bSuccess = true;
        int iMaxOperationPerTx = 0;
        int iMaxInstructionPerTx = 0;
        try {
            if (this.m_enableStatisticsCheckBox != null && this.m_sysConfig.getStatisticsCollection() ^ this.m_enableStatisticsCheckBox.isSelected()) {
                this.m_bDirty = true;
                this.m_sysConfig.setStatisticsCollection(this.m_enableStatisticsCheckBox.isSelected());
            }
            if ((iMaxOperationPerTx = this.fetchMaxOperationPerTx()) > 0) {
                if (iMaxOperationPerTx != this.m_originalMaxOpPerTx) {
                    this.m_bDirty = true;
                    this.m_sysConfig.setMaxDBOperations(iMaxOperationPerTx);
                }
                if ((iMaxInstructionPerTx = this.fetchMaxInstructionPerTx()) > 0) {
                    if (iMaxInstructionPerTx != this.m_originalMaxInstPerTx) {
                        this.m_bDirty = true;
                        this.m_sysConfig.setMaxInstructions(iMaxInstructionPerTx);
                    }
                } else {
                    bSuccess = !this.m_sysConfig.getIsRetrievedFromServer();
                }
            } else {
                boolean bl = bSuccess = !this.m_sysConfig.getIsRetrievedFromServer();
            }
            if (this.m_sysConfig.getTrackAttachmentReferences() ^ this.m_enableTrackAttachmentsCheckBox.isSelected()) {
                this.m_bDirty = true;
                this.m_sysConfig.setTrackAttachmentReferences(this.m_enableTrackAttachmentsCheckBox.isSelected());
            }
            try {
                String newObjectStoreSymbolicName = this.m_objectStoreIdTextField.getText();
                String currentObjectStoreSymbolicName = null;
                try {
                    currentObjectStoreSymbolicName = this.m_sysConfig.getObjectStoreSymbolicName();
                }
                catch (VWException ex) {
                    ex.printStackTrace();
                }
                if (newObjectStoreSymbolicName == null && currentObjectStoreSymbolicName != null || currentObjectStoreSymbolicName == null || !currentObjectStoreSymbolicName.contentEquals(newObjectStoreSymbolicName)) {
                    this.m_bDirty = true;
                    this.m_sysConfig.setObjectStoreSymbolicName(newObjectStoreSymbolicName);
                }
            }
            catch (VWException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                bSuccess = false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    public void releaseResources() {
        if (this.m_enableStatisticsCheckBox != null) {
            this.m_enableStatisticsCheckBox.removeAll();
            this.m_enableStatisticsCheckBox = null;
        }
        if (this.m_opPerTxComboBox != null) {
            this.m_opPerTxComboBox.removeAllItems();
            this.m_opPerTxComboBox.removeAll();
            this.m_opPerTxComboBox = null;
        }
        if (this.m_instPerTxComboBox != null) {
            this.m_instPerTxComboBox.removeAllItems();
            this.m_instPerTxComboBox.removeAll();
            this.m_instPerTxComboBox = null;
        }
        if (this.m_enableTrackAttachmentsCheckBox != null) {
            this.m_enableTrackAttachmentsCheckBox.removeAll();
            this.m_enableTrackAttachmentsCheckBox = null;
        }
        if (this.m_objectStoreIdTextField != null) {
            this.m_objectStoreIdTextField.removeAll();
            this.m_objectStoreIdTextField = null;
        }
        this.m_sysConfig = null;
        if (this.m_modelOperationPerTx != null) {
            this.m_modelOperationPerTx.removeAllElements();
            this.m_modelOperationPerTx = null;
        }
        if (this.m_modelInstructionPerTx != null) {
            this.m_modelInstructionPerTx.removeAllElements();
            this.m_modelInstructionPerTx = null;
        }
        this.removeAll();
    }

    protected JPanel createStatisticsPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new VWTitledBorder(VWResource.Statistics));
            VWAccessibilityHelper.setAccessibility(mainPanel, this, VWResource.Statistics, VWResource.Statistics);
            String title = VWResource.Statistics + " ";
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(4, 4, 4, 10);
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.fill = 2;
            this.m_enableStatisticsCheckBox = new JCheckBox(VWResource.EnableStatistics);
            VWAccessibilityHelper.setAccessibility(this.m_enableStatisticsCheckBox, this, title + VWResource.EnableStatistics, title + VWResource.EnableStatistics);
            this.m_enableStatisticsCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (this.m_sysConfig.getStatisticsCollection()) {
                this.m_enableStatisticsCheckBox.setSelected(true);
            }
            mainPanel.add((Component)this.m_enableStatisticsCheckBox, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 0;
            mainPanel.add(Box.createHorizontalStrut(60), gbConst);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createPerformancePanel() {
        try {
            this.m_modelOperationPerTx = new DefaultComboBoxModel();
            this.m_opPerTxComboBox = new JComboBox(this.m_modelOperationPerTx);
            this.m_opPerTxComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_opPerTxComboBox.setEditable(true);
            this.m_originalMaxOpPerTx = this.m_sysConfig.getMaxDBOperations();
            this.m_modelOperationPerTx.addElement("100");
            this.m_modelOperationPerTx.addElement("200");
            this.m_modelOperationPerTx.addElement("300");
            this.m_modelOperationPerTx.addElement("400");
            this.m_modelOperationPerTx.addElement("500");
            this.m_opPerTxComboBox.setSelectedItem(String.valueOf(this.m_originalMaxOpPerTx));
            VWAccessibilityHelper.setAccessibility(this.m_opPerTxComboBox, this, VWResource.EnableStatistics, VWResource.EnableStatistics);
            this.m_opPerTxComboBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_modelInstructionPerTx = new DefaultComboBoxModel();
            this.m_instPerTxComboBox = new JComboBox(this.m_modelInstructionPerTx);
            this.m_instPerTxComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_instPerTxComboBox.setEditable(true);
            this.m_originalMaxInstPerTx = this.m_sysConfig.getMaxInstructions();
            this.m_modelInstructionPerTx.addElement("100");
            this.m_modelInstructionPerTx.addElement("200");
            this.m_modelInstructionPerTx.addElement("300");
            this.m_modelInstructionPerTx.addElement("400");
            this.m_modelInstructionPerTx.addElement("500");
            this.m_instPerTxComboBox.setSelectedItem(String.valueOf(this.m_originalMaxInstPerTx));
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new VWTitledBorder(VWResource.TransactionSettings));
            VWAccessibilityHelper.setAccessibility(mainPanel, this, VWResource.TransactionSettings, VWResource.TransactionSettings);
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.TransactionSettings + " ";
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 0;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 21;
            gbConst.insets = new Insets(4, 4, 4, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 0.0;
            JLabel opPerTxLabel = new JLabel(VWResource.s_label.toString(VWResource.MaxOpPerTx));
            mainPanel.add((Component)opPerTxLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(opPerTxLabel, this, title + VWResource.MaxOpPerTx, title + VWResource.MaxOpPerTx);
            opPerTxLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            gbConst.insets = new Insets(4, 4, 4, 10);
            mainPanel.add((Component)this.m_opPerTxComboBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_opPerTxComboBox, this, title + VWResource.MaxOpPerTx, title + VWResource.MaxOpPerTx);
            this.m_opPerTxComboBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setLabelFor(opPerTxLabel, this.m_opPerTxComboBox);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            gbConst.insets = new Insets(4, 4, 4, 10);
            JLabel instPerTxLabel = new JLabel(VWResource.s_label.toString(VWResource.MaxInstPerTx));
            mainPanel.add((Component)instPerTxLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(instPerTxLabel, this, title + VWResource.MaxInstPerTx, title + VWResource.MaxInstPerTx);
            instPerTxLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            gbConst.insets = new Insets(4, 4, 4, 10);
            mainPanel.add((Component)this.m_instPerTxComboBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_instPerTxComboBox, this, title + VWResource.MaxInstPerTx, title + VWResource.MaxInstPerTx);
            this.m_instPerTxComboBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setLabelFor(instPerTxLabel, this.m_instPerTxComboBox);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createTrackAttachmentsPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new VWTitledBorder(VWResource.AttachmentTracking));
            VWAccessibilityHelper.setAccessibility(mainPanel, this, VWResource.AttachmentTracking, VWResource.AttachmentTracking);
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.AttachmentTracking + " ";
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(4, 4, 4, 10);
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.fill = 2;
            this.m_enableTrackAttachmentsCheckBox = new JCheckBox(VWResource.EnableAttachmentTracking);
            if (this.m_sysConfig.getTrackAttachmentReferences()) {
                this.m_enableTrackAttachmentsCheckBox.setSelected(true);
            }
            mainPanel.add((Component)this.m_enableTrackAttachmentsCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_enableTrackAttachmentsCheckBox, this, title + VWResource.EnableAttachmentTracking, title + VWResource.EnableAttachmentTracking);
            this.m_enableTrackAttachmentsCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 1;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 0;
            mainPanel.add(Box.createHorizontalStrut(60), gbConst);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createObjectStoreIdPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new VWTitledBorder(VWResource.ObjectStoreInformation));
            VWAccessibilityHelper.setAccessibility(mainPanel, this, VWResource.ObjectStoreInformation, VWResource.ObjectStoreInformation);
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.ObjectStoreInformation + " ";
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.insets = new Insets(4, 4, 4, 10);
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.fill = 0;
            JLabel textLabel = new JLabel(VWResource.ObjectStoreSymbolicName);
            mainPanel.add((Component)textLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(textLabel, this, title + VWResource.ObjectStoreSymbolicName, title + VWResource.ObjectStoreSymbolicName);
            textLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.fill = 2;
            this.m_objectStoreIdTextField = new JTextField();
            String objectStoreSymbolicName = null;
            try {
                objectStoreSymbolicName = this.m_sysConfig.getObjectStoreSymbolicName();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (objectStoreSymbolicName != null) {
                this.m_objectStoreIdTextField.setText(objectStoreSymbolicName);
            }
            mainPanel.add((Component)this.m_objectStoreIdTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_objectStoreIdTextField, this, title + VWResource.ObjectStoreSymbolicName, title + VWResource.ObjectStoreSymbolicName);
            this.m_objectStoreIdTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 0;
            mainPanel.add(Box.createHorizontalStrut(60), gbConst);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

